<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\TherapistProfile;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class TherapistSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ensure counselor role exists
        $counselorRole = Role::firstOrCreate(['name' => 'counselor', 'guard_name' => 'web']);

        $therapists = [
            [
                'name' => 'Dr. Sarah Chen',
                'email' => 'sarah.chen@maakaba.com',
                'specializations' => ['Trauma & PTSD', 'Anxiety'],
                'bio' => 'Specializing in trauma-informed care with over 10 years of experience.',
                'years_experience' => 10,
            ],
            [
                'name' => 'Dr. Michael Torres',
                'email' => 'michael.torres@maakaba.com',
                'specializations' => ['Couples Therapy', 'Marriage Counseling'],
                'bio' => 'Expert in relationship dynamics and couples communication.',
                'years_experience' => 8,
            ],
            [
                'name' => 'Dr. Amara Johnson',
                'email' => 'amara.johnson@maakaba.com',
                'specializations' => ['Family Therapy', 'Child Psychology'],
                'bio' => 'Passionate about helping families heal and grow together.',
                'years_experience' => 12,
            ],
            [
                'name' => 'Dr. David Kim',
                'email' => 'david.kim@maakaba.com',
                'specializations' => ['Teen Counseling', 'Depression'],
                'bio' => 'Dedicated to supporting adolescents through life challenges.',
                'years_experience' => 7,
            ],
        ];

        foreach ($therapists as $therapistData) {
            // Create or update user
            $user = User::updateOrCreate(
                ['email' => $therapistData['email']],
                [
                    'name' => $therapistData['name'],
                    'password' => Hash::make('password123'), // Default password
                ]
            );

            // Assign counselor role
            if (!$user->hasRole('counselor')) {
                $user->assignRole('counselor');
            }

            // Create or update therapist profile
            TherapistProfile::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'specializations' => $therapistData['specializations'],
                    'bio' => $therapistData['bio'],
                    'years_experience' => $therapistData['years_experience'],
                    'accepts_new_clients' => true,
                    'is_active' => true,
                ]
            );
        }

        $this->command->info('Therapists seeded successfully!');
    }
}
