<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Testimonial;
use App\Models\TestimonialsPage;

class TestimonialsSeeder extends Seeder
{
    public function run(): void
    {
        // Create testimonials page content
        TestimonialsPage::updateOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Stories of Transformation',
                'hero_subtitle' => 'Real people, real healing, real hope',
                'stats_title' => 'Our Impact',
                'video_section_title' => 'Hear Their Stories',
                'video_section_subtitle' => 'Watch real clients share their healing journeys',
                'gallery_section_title' => 'Experience Our Healing Space',
                'gallery_section_subtitle' => 'A beautiful, serene environment designed for your comfort and healing',
                'testimonials_section_title' => 'What Our Clients Say',
                'faq_section_title' => 'Frequently Asked Questions',
                'faq_section_subtitle' => 'Everything you need to know to get started',
                'cta_title' => 'Ready to Begin Your Journey?',
                'cta_paragraph' => 'Join hundreds of others who have found healing, hope, and transformation at MaaKaBa',
            ]
        );

        // Create sample testimonials
        $testimonials = [
            [
                'client_name' => 'Sarah M.',
                'role' => 'Individual Counseling Client',
                'message' => 'MaaKaBa changed my life. The integration of faith and therapy helped me find peace I never thought possible. The counselors here truly understand the connection between spiritual and mental wellness.',
                'rating' => 5,
                'display_order' => 1,
            ],
            [
                'client_name' => 'David and Jennifer L.',
                'role' => 'Couples Therapy Clients',
                'message' => 'Our marriage was struggling, but the couples therapy here saved us. We are stronger than ever. The therapists helped us communicate better and rediscover our love for each other.',
                'rating' => 5,
                'display_order' => 2,
            ],
            [
                'client_name' => 'Marcus T.',
                'role' => 'Trauma Therapy Client',
                'message' => 'The trauma therapy I received was life-changing. I finally feel like I can breathe again. After years of struggling with PTSD, I have found healing and hope through their specialized care.',
                'rating' => 5,
                'display_order' => 3,
            ],
            [
                'client_name' => 'Alex K.',
                'role' => 'Teen Counseling Client',
                'message' => 'As a teenager, I felt lost. The counselors here understood me and helped me find my way. They created a safe space where I could be myself and work through my challenges.',
                'rating' => 5,
                'display_order' => 4,
            ],
            [
                'client_name' => 'Priya S.',
                'role' => 'Holistic Wellness Client',
                'message' => 'The holistic approach addresses not just my mind, but my body and spirit too. Truly transformative. I have learned to integrate mindfulness, nutrition, and spiritual practices into my daily life.',
                'rating' => 5,
                'display_order' => 5,
            ],
            [
                'client_name' => 'The Johnson Family',
                'role' => 'Family Therapy Clients',
                'message' => 'Family therapy helped us communicate better and heal together. We are so grateful. Our family bonds are stronger than ever, and we have learned valuable tools for resolving conflicts.',
                'rating' => 5,
                'display_order' => 6,
            ],
            [
                'client_name' => 'Rachel W.',
                'role' => 'Spiritual Guidance Client',
                'message' => 'The spiritual guidance I received helped me reconnect with my faith during a difficult time. The counselors respect all faith traditions and helped me find strength in my beliefs.',
                'rating' => 5,
                'display_order' => 7,
            ],
            [
                'client_name' => 'Michael B.',
                'role' => 'Individual Counseling Client',
                'message' => 'After struggling with anxiety for years, I finally found relief through the compassionate care at MaaKaBa. The therapists use evidence-based techniques combined with spiritual wisdom.',
                'rating' => 5,
                'display_order' => 8,
            ],
            [
                'client_name' => 'Lisa and Tom R.',
                'role' => 'Couples Therapy Clients',
                'message' => 'We came here on the brink of divorce. Now we are celebrating our renewed commitment to each other. The therapy gave us tools we will use for the rest of our lives.',
                'rating' => 5,
                'display_order' => 9,
            ],
        ];

        foreach ($testimonials as $testimonialData) {
            Testimonial::create([
                'client_name' => $testimonialData['client_name'],
                'role' => $testimonialData['role'],
                'message' => $testimonialData['message'],
                'rating' => $testimonialData['rating'],
                'display_order' => $testimonialData['display_order'],
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now(),
            ]);
        }

        $this->command->info('✓ Created ' . count($testimonials) . ' testimonials');
        $this->command->info('✓ Created testimonials page content');
    }
}
