<?php

namespace Database\Seeders;

use App\Models\Testimonial;
use Illuminate\Database\Seeder;

class TestimonialSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $testimonials = [
            [
                'client_name' => 'Sarah M.',
                'email' => 'sarah.m@example.com',
                'message' => 'Working with Dr. Chen has been life-changing. After years of struggling with PTSD, I finally feel like I can breathe again. The EMDR therapy was incredibly effective, and the compassionate approach made all the difference.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(5),
            ],
            [
                'client_name' => 'Michael & Jennifer R.',
                'email' => 'mjr@example.com',
                'message' => 'We were on the verge of divorce when we started couples counseling with Michael Rodriguez. His guidance helped us rediscover what brought us together. We\'re now stronger than ever. Truly grateful!',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(10),
            ],
            [
                'client_name' => 'David T.',
                'email' => 'david.t@example.com',
                'message' => 'The mindfulness and meditation sessions with Dr. Patel have transformed how I handle stress. I\'ve learned practical tools that I use daily. My anxiety has significantly decreased, and I feel more centered.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(15),
            ],
            [
                'client_name' => 'Lisa K.',
                'email' => 'lisa.k@example.com',
                'message' => 'James Thompson is an exceptional therapist. His compassionate approach helped me navigate a difficult life transition. I\'ve grown so much in just a few months and now feel equipped to handle whatever comes my way.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(20),
            ],
            [
                'client_name' => 'The Johnson Family',
                'email' => 'johnson.family@example.com',
                'message' => 'Family therapy with Dr. Wong helped our family communicate better and understand each other. Our teenage daughter is doing so much better, and we\'re all closer now. Thank you for bringing peace back to our home.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(25),
            ],
            [
                'client_name' => 'Robert P.',
                'email' => 'robert.p@example.com',
                'message' => 'I was skeptical about therapy at first, but the team at MaaKaBa made me feel comfortable from day one. The holistic approach to wellness has improved not just my mental health, but my overall quality of life.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(30),
            ],
            [
                'client_name' => 'Emily W.',
                'email' => 'emily.w@example.com',
                'message' => 'After struggling with depression for years, I finally found hope here. The combination of therapy and wellness coaching gave me the tools to rebuild my life. Forever grateful to this amazing team.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(35),
            ],
            [
                'client_name' => 'Marcus S.',
                'email' => 'marcus.s@example.com',
                'message' => 'The Platinum membership has been worth every penny. Having unlimited access to therapy and a dedicated wellness coach has been invaluable for managing my work stress and anxiety.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(40),
            ],
            [
                'client_name' => 'Anonymous',
                'email' => null,
                'message' => 'This is an outstanding facility with caring professionals. I feel heard, understood, and supported. The progress I\'ve made in healing from trauma has exceeded my expectations.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(45),
            ],
            [
                'client_name' => 'Patricia L.',
                'email' => 'patricia.l@example.com',
                'message' => 'MaaKaBa Sanctuary truly lives up to its name. It\'s a safe haven where I can work through my challenges without judgment. The integrated approach to mind, body, and spirit is exactly what I needed.',
                'consent' => true,
                'status' => 'approved',
                'approved_at' => now()->subDays(50),
            ],
            [
                'client_name' => 'New Submission',
                'email' => 'new.client@example.com',
                'message' => 'Just started therapy here last month and already seeing positive changes. Looking forward to continuing my journey with this wonderful team.',
                'consent' => true,
                'status' => 'pending_moderation',
                'approved_at' => null,
            ],
        ];

        foreach ($testimonials as $testimonial) {
            Testimonial::updateOrCreate(
                ['email' => $testimonial['email']], // Find by email
                $testimonial // Update or create with this data
            );
        }
    }
}
