<?php

namespace Database\Seeders;

use App\Models\TeamPage;
use Illuminate\Database\Seeder;

class TeamPageSeeder extends Seeder
{
    public function run(): void
    {
        TeamPage::updateOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Meet Our Team',
                'hero_subtitle' => 'Compassionate professionals dedicated to your healing journey',
                'hero_image_path' => null,
                'intro_title' => 'Our Dedicated Team',
                'intro_paragraph' => 'At MaaKaBa, our team consists of licensed therapists, counselors, and wellness professionals who are passionate about integrating faith and psychology to support your mental health journey.',
                'values_title' => 'Our Core Values',
                'values_subtitle' => 'The principles that guide our work and define our commitment to you',
                'cta_title' => 'Ready to Begin Your Journey?',
                'cta_paragraph' => 'Our team is here to support you. Schedule a consultation today and take the first step toward healing and wholeness.',
            ]
        );
    }
}
