<?php

namespace Database\Seeders;

use App\Models\TeamMember;
use Illuminate\Database\Seeder;

class TeamMembersSeeder extends Seeder
{
    public function run(): void
    {
        $teamMembers = [
            [
                'name' => 'Dr. Sarah Johnson',
                'title' => 'Founder & Lead Pastoral Psychotherapist',
                'credentials' => 'Ph.D. in Clinical Psychology, M.Div. Theology, Licensed Professional Counselor',
                'specialties' => 'Trauma Recovery, Spiritual Integration, Family Systems',
                'bio' => 'With over 15 years of experience, Dr. Johnson founded MaaKaBa to create a healing space where faith and psychology unite. Her compassionate approach has helped hundreds find wholeness.',
                'photo_path' => null,
                'email' => null,
                'phone' => null,
                'social_links' => null,
            ],
            [
                'name' => 'Rev. Michael Chen',
                'title' => 'Senior Counselor',
                'credentials' => 'M.A. Counseling Psychology, M.Div. Pastoral Care, LCPC',
                'specialties' => 'Individual Therapy, Grief Counseling, Mindfulness',
                'bio' => 'Rev. Chen brings a unique blend of Eastern contemplative practices and Western therapeutic approaches, helping clients find peace and clarity in life\'s challenges.',
                'photo_path' => null,
                'email' => null,
                'phone' => null,
                'social_links' => null,
            ],
            [
                'name' => 'Dr. Emily Rodriguez',
                'title' => 'Family & Teen Specialist',
                'credentials' => 'Psy.D. Family Psychology, Certificate in Adolescent Therapy',
                'specialties' => 'Family Therapy, Teen Counseling, Parenting Support',
                'bio' => 'Dr. Rodriguez has a gift for connecting with teens and families. Her warm, non-judgmental approach creates safety for exploring difficult emotions and building stronger relationships.',
                'photo_path' => null,
                'email' => null,
                'phone' => null,
                'social_links' => null,
            ],
            [
                'name' => 'Pastor David Williams',
                'title' => 'Pastoral Counselor',
                'credentials' => 'M.A. Pastoral Counseling, Ordained Minister, LPC',
                'specialties' => 'Spiritual Direction, Crisis Counseling, Couples Therapy',
                'bio' => 'Pastor Williams integrates deep theological understanding with clinical expertise, guiding individuals and couples through faith-based healing and relationship restoration.',
                'photo_path' => null,
                'email' => null,
                'phone' => null,
                'social_links' => null,
            ],
        ];

        foreach ($teamMembers as $member) {
            TeamMember::updateOrCreate(
                ['name' => $member['name']],
                $member
            );
        }
    }
}
