<?php

namespace Database\Seeders;

use App\Models\TeamMember;
use Illuminate\Database\Seeder;

class TeamMemberSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $teamMembers = [
            [
                'name' => 'Dr. Sarah Chen',
                'title' => 'Licensed Clinical Psychologist',
                'bio' => 'Dr. Sarah Chen specializes in trauma therapy and PTSD with over 15 years of experience. She uses a compassionate, evidence-based approach combining EMDR and cognitive behavioral therapy.',
                'credentials' => 'Ph.D. Clinical Psychology, EMDR Certified, Licensed Psychologist',
                'email' => 'sarah.chen@maakaba.com',
                'phone' => '+1 (555) 123-4567',
            ],
            [
                'name' => 'Michael Rodriguez',
                'title' => 'Marriage & Family Therapist',
                'bio' => 'Michael brings warmth and insight to couples and family therapy. With 12 years of experience, he helps families navigate challenges and build stronger, more fulfilling relationships.',
                'credentials' => 'MA Family Therapy, LMFT, Gottman Method Certified',
                'email' => 'michael.rodriguez@maakaba.com',
                'phone' => '+1 (555) 123-4568',
            ],
            [
                'name' => 'Dr. Aisha Patel',
                'title' => 'Integrative Wellness Coach',
                'bio' => 'Dr. Patel blends Eastern wisdom with Western psychology to guide clients toward holistic wellness. She specializes in mindfulness, meditation, and lifestyle transformation.',
                'credentials' => 'Ph.D. Integrative Health, RYT-500, Certified Health Coach',
                'email' => 'aisha.patel@maakaba.com',
                'phone' => '+1 (555) 123-4569',
            ],
            [
                'name' => 'James Thompson',
                'title' => 'Licensed Clinical Social Worker',
                'bio' => 'James specializes in anxiety, depression, and life transitions. His approach is client-centered and strength-based, helping individuals discover their resilience and potential.',
                'credentials' => 'MSW, LCSW, Certified in ACT and DBT',
                'email' => 'james.thompson@maakaba.com',
                'phone' => '+1 (555) 123-4570',
            ],
            [
                'name' => 'Dr. Emily Wong',
                'title' => 'Child & Adolescent Specialist',
                'bio' => 'Dr. Wong has dedicated her career to supporting children and adolescents through developmental challenges, anxiety, and behavioral issues with creativity and compassion.',
                'credentials' => 'Psy.D., Licensed Child Psychologist, Play Therapy Certified',
                'email' => 'emily.wong@maakaba.com',
                'phone' => '+1 (555) 123-4571',
            ],
        ];

        foreach ($teamMembers as $member) {
            TeamMember::updateOrCreate(
                ['email' => $member['email']], // Find by email
                $member // Update or create with this data
            );
        }
    }
}
