<?php

namespace Database\Seeders;

use App\Models\Subscription;
use Illuminate\Database\Seeder;

class SubscriptionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subscriptions = [
            [
                'name' => 'Sarah Johnson',
                'email' => 'sarah.johnson@example.com',
                'phone' => '+1 (555) 123-4567',
                'plan' => 'premium',
                'plan_price' => '$199/month',
                'status' => 'active',
                'start_date' => now()->subDays(30),
                'end_date' => now()->addMonths(11),
                'notes' => 'Active member, very engaged',
                'created_at' => now()->subDays(30),
            ],
            [
                'name' => 'Michael Chen',
                'email' => 'michael.chen@example.com',
                'phone' => '+1 (555) 234-5678',
                'plan' => 'basic',
                'plan_price' => '$99/month',
                'status' => 'active',
                'start_date' => now()->subDays(15),
                'end_date' => now()->addMonths(11)->subDays(15),
                'notes' => 'New member, started 2 weeks ago',
                'created_at' => now()->subDays(15),
            ],
            [
                'name' => 'Emily Rodriguez',
                'email' => 'emily.rodriguez@example.com',
                'phone' => '+1 (555) 345-6789',
                'plan' => 'platinum',
                'plan_price' => '$299/month',
                'status' => 'active',
                'start_date' => now()->subDays(60),
                'end_date' => now()->addMonths(10),
                'notes' => 'Long-term member, excellent progress',
                'created_at' => now()->subDays(60),
            ],
            [
                'name' => 'David Thompson',
                'email' => 'david.thompson@example.com',
                'phone' => '+1 (555) 456-7890',
                'plan' => 'premium',
                'plan_price' => '$199/month',
                'status' => 'pending',
                'start_date' => null,
                'end_date' => null,
                'notes' => 'Awaiting payment confirmation',
                'created_at' => now()->subDays(2),
            ],
            [
                'name' => 'Jessica Martinez',
                'email' => 'jessica.martinez@example.com',
                'phone' => null,
                'plan' => 'basic',
                'plan_price' => '$99/month',
                'status' => 'pending',
                'start_date' => null,
                'end_date' => null,
                'notes' => 'New subscription request',
                'created_at' => now()->subHours(5),
            ],
            [
                'name' => 'Robert Wilson',
                'email' => 'robert.wilson@example.com',
                'phone' => '+1 (555) 567-8901',
                'plan' => 'premium',
                'plan_price' => '$199/month',
                'status' => 'cancelled',
                'start_date' => now()->subMonths(6),
                'end_date' => now()->subMonths(1),
                'notes' => 'Cancelled due to relocation',
                'created_at' => now()->subMonths(6),
            ],
        ];

        foreach ($subscriptions as $subscription) {
            Subscription::create($subscription);
        }

        $this->command->info('Subscriptions seeded successfully!');
    }
}
