<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Site Configuration
            ['key' => 'site_name', 'value' => 'MaaKaBa Holistic Counseling Sanctuary'],
            ['key' => 'tagline', 'value' => 'Transform Your Journey'],
            ['key' => 'site_description', 'value' => 'MaaKaBa Holistic Counseling Sanctuary offers a compassionate and collaborative approach to emotional wellness and psychological health, specializing in treating sadness, anxiety, anger, difficulty sleeping, changes in appetite, feelings of worthlessness, depression, and trauma with a particular focus on teens, adults, and families.'],
            ['key' => 'contact_email', 'value' => 'contact@maakaba.com'],
            ['key' => 'contact_phone', 'value' => '+1 (555) 123-4567'],
            ['key' => 'address', 'value' => '123 Wellness Way, Harmony City, HC 12345'],
            ['key' => 'timezone', 'value' => 'America/New_York'],

            // Branding
            ['key' => 'primary_color', 'value' => '#0F4A3C'],
            ['key' => 'secondary_color', 'value' => '#E8DCC2'],
            ['key' => 'accent_color', 'value' => '#D4B26A'],
            ['key' => 'primary_font', 'value' => 'Playfair Display'],
            ['key' => 'secondary_font', 'value' => 'Inter'],

            // Notifications
            ['key' => 'email_notifications', 'value' => true],
            ['key' => 'sms_notifications', 'value' => false],
            ['key' => 'booking_alerts', 'value' => true],
            ['key' => 'membership_alerts', 'value' => true],
            ['key' => 'marketing_emails', 'value' => false],
            ['key' => 'weekly_reports', 'value' => true],

            // Security
            ['key' => 'two_factor_auth', 'value' => false],
            ['key' => 'session_timeout', 'value' => '60'],
            ['key' => 'password_expiry', 'value' => '90'],
            ['key' => 'ip_whitelist', 'value' => false],
        ];

        foreach ($settings as $setting) {
            SiteSetting::updateOrCreate(
                ['key' => $setting['key']],
                ['value' => is_array($setting['value']) ? json_encode($setting['value']) : $setting['value']]
            );
        }
    }
}
