<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ServicesPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \App\Models\ServicesPage::updateOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Our Therapeutic Services',
                'hero_subtitle' => 'Comprehensive, faith-integrated counseling for every stage of your healing journey',
                'intro_title' => 'Personalized Care for Your Unique Journey',
                'intro_paragraph_1' => 'At MaaKaBa, we understand that every person\'s path to wellness is unique. Our comprehensive range of services is designed to meet you wherever you are in your journey, providing the specialized support you need.',
                'intro_paragraph_2' => 'All our services integrate evidence-based therapeutic approaches with pastoral care, honoring both your psychological needs and spiritual beliefs.',
                'intro_button_text' => 'Schedule a Consultation',
                'intro_button_url' => '/contact',
                'intro_image_path' => '/assets/counseling-session.jpg',
            ]
        );
    }
}
