<?php

namespace Database\Seeders;

use App\Models\Service;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'title' => 'Individual Counseling',
                'excerpt' => 'One-on-one therapy sessions tailored to your unique needs, challenges, and goals.',
                'content' => "Personalized therapy sessions designed specifically for you.\n\n• Depression and anxiety management\n• Life transitions and adjustment\n• Self-esteem and personal growth\n• Grief and loss support\n• Stress management techniques\n\nOur individual counseling provides a safe, confidential space where you can explore your thoughts, feelings, and experiences with a trained professional who understands both psychological principles and spiritual dimensions of healing.",
                'image_path' => '/assets/individual-counseling.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Teen & Youth Counseling',
                'excerpt' => 'Specialized support for adolescents navigating the challenges of growing up.',
                'content' => "Compassionate guidance for teens and young adults.\n\n• Identity development and self-discovery\n• Academic and social pressures\n• Family relationship dynamics\n• Bullying and peer issues\n• Emotional regulation skills\n\nAdolescence is a critical time of development. Our teen counseling provides age-appropriate support that respects their growing independence while offering the guidance they need.",
                'image_path' => '/assets/teen-counseling.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Family Therapy',
                'excerpt' => 'Strengthen family bonds and improve communication in a supportive environment.',
                'content' => "Building stronger families through understanding and connection.\n\n• Parent-child relationship building\n• Conflict resolution strategies\n• Blended family dynamics\n• Communication skill development\n• Family system healing\n\nFamily therapy helps all members understand each other better, resolve conflicts constructively, and create a more harmonious home environment.",
                'image_path' => '/assets/family-therapy.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Couples Counseling',
                'excerpt' => 'Build stronger, healthier relationships through understanding and connection.',
                'content' => "Nurture your relationship and deepen your bond.\n\n• Pre-marital counseling\n• Communication enhancement\n• Conflict resolution\n• Trust rebuilding\n• Intimacy and connection\n\nWhether you're preparing for marriage, working through challenges, or simply want to strengthen your relationship, our couples counseling provides tools and insights for lasting partnership.",
                'image_path' => '/assets/couples-therapy.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Trauma & PTSD Therapy',
                'excerpt' => 'Evidence-based approaches to heal from traumatic experiences in a safe space.',
                'content' => "Specialized trauma-informed care for healing and recovery.\n\n• EMDR (Eye Movement Desensitization and Reprocessing)\n• Trauma-focused cognitive therapy\n• Safety and stabilization\n• Processing traumatic memories\n• Resilience building\n\nOur trauma therapy uses proven methods to help you process difficult experiences, reduce symptoms, and reclaim your life from the impact of trauma.",
                'image_path' => '/assets/trauma-therapy.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Spiritual Guidance',
                'excerpt' => 'Explore questions of faith, meaning, and purpose alongside mental health.',
                'content' => "Integrating faith and psychology for holistic healing.\n\n• Faith and doubt exploration\n• Spiritual crisis support\n• Integration of faith and psychology\n• Prayer and meditation practices\n• Purpose and meaning discovery\n\nOur spiritual guidance honors your faith journey while addressing mental health concerns, recognizing that spiritual and emotional well-being are deeply interconnected.",
                'image_path' => '/assets/spiritual-guidance.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Holistic Wellness',
                'excerpt' => 'Mind-body-spirit integration for complete emotional and spiritual health.',
                'content' => "Comprehensive wellness addressing all aspects of your being.\n\n• Mindfulness and meditation\n• Breathwork techniques\n• Somatic experiencing\n• Nutrition and mental health\n• Lifestyle and self-care planning\n\nOur holistic approach recognizes that true wellness encompasses mental, physical, and spiritual health, creating personalized plans for complete well-being.",
                'image_path' => '/assets/holistic-approach.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Group Therapy',
                'excerpt' => 'Find community and shared healing in supportive group settings.',
                'content' => "Connect with others on similar journeys.\n\n• Support groups for specific issues\n• Skills-based groups\n• Faith-based recovery groups\n• Peer support and connection\n• Shared growth experiences\n\nGroup therapy offers the unique benefit of learning from others' experiences, building community, and discovering you're not alone in your struggles.",
                'image_path' => '/assets/meditation-group.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Initial Consultation',
                'excerpt' => 'Free 30-minute session for new clients to explore counseling options.',
                'content' => "Online or in-person, this is designated for new clients to answer any questions they may have, discuss their reasons for seeking counseling and what to expect from therapy, explore what they are looking for in a clinician and what services they may benefit from.\n\n• Duration: 30 minutes\n• Cost: Free\n• Format: Online or in-person\n• Purpose: Get to know us and explore your needs",
                'image_path' => '/assets/consultation.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Holistic Intake Session',
                'excerpt' => 'Comprehensive 90-minute session to deeply understand your unique journey.',
                'content' => "This session is different from an initial consultation session as it allows the clinician to more deeply understand the client and their lived experience. This intake session allows the client to relay important history and background information (including biological/medical, psychological, and socio-cultural aspects of themselves), discuss in detail what brings them to counseling, and begin to identify specific goals with their clinician.\n\n• Duration: 90 minutes\n• Cost: $100-$295\n• Comprehensive assessment\n• Goal setting with your clinician",
                'image_path' => '/assets/intake-session.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Individual Therapy Sessions',
                'excerpt' => 'Personalized therapy sessions with DBT phone coaching between sessions.',
                'content' => "Individual session fees include DBT phone coaching between sessions (if therapist offers this) and collaborations with other providers, such as psychiatrists, dietitians, and family therapists.\n\n50-Minute Session: $75-$225\n80-Minute Session: $100-$260\n\n• Evidence-based therapeutic approaches\n• Between-session support available\n• Collaborative care with other providers",
                'image_path' => '/assets/individual-session.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Family & Relationship Therapy',
                'excerpt' => 'Strengthen family bonds and relationships with specialized support.',
                'content' => "Family and relationship counseling and support coaching (coaching for parents or support persons) fees include between session coaching (if therapist offers this) and collaborations with other providers, such as psychiatrists, dietitians, and individual or group therapists.\n\n50-Minute Session: $100-$260\n80-Minute Session: $125-$295\n\n• Family counseling\n• Relationship therapy\n• Parent coaching\n• Support person coaching",
                'image_path' => '/assets/family-session.jpg',
                'published_at' => now(),
            ],
            [
                'title' => 'Group Therapy & Workshops',
                'excerpt' => 'Foster compassion and connection with others on similar journeys.',
                'content' => "Group therapy is a wonderful way to foster compassion and connection with others who may have similar or the same concerns or struggles as you. Groups support each other, learn together, and heal alongside each other.\n\nWorkshops are short-term and intensive educational-based groups that aim at building awareness, insight, and knowledge around a specific topic or issue.\n\n• Typical 2-hour group: $80 per group\n• Workshop pricing varies per workshop\n• Community support and shared healing\n• Educational and therapeutic groups",
                'image_path' => '/assets/group-workshop.jpg',
                'published_at' => now(),
            ],
        ];

        foreach ($services as $service) {
            Service::updateOrCreate(
                ['slug' => Str::slug($service['title'])],
                [
                    'title' => $service['title'],
                    'excerpt' => $service['excerpt'],
                    'content' => $service['content'],
                    'image_path' => $service['image_path'],
                    'published_at' => $service['published_at'],
                ]
            );
        }
    }
}
