<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create roles
        $roles = [
            'super-admin',
            'admin',
            'counselor',
            'editor',
            'guest',
        ];

        foreach ($roles as $roleName) {
            Role::firstOrCreate(['name' => $roleName, 'guard_name' => 'web']);
        }

        // Create permissions
        $permissions = [
            // Content management
            'view services',
            'create services',
            'edit services',
            'delete services',
            'view posts',
            'create posts',
            'edit posts',
            'delete posts',
            'view team',
            'create team',
            'edit team',
            'delete team',
            
            // Appointment management
            'view appointments',
            'view own appointments',
            'edit appointments',
            'delete appointments',
            
            // Inquiry management
            'view inquiries',
            'delete inquiries',
            
            // Testimonial management
            'view testimonials',
            'approve testimonials',
            'delete testimonials',
            
            // Media management
            'upload media',
            'delete media',
            
            // Site settings
            'view settings',
            'edit settings',
            
            // Analytics
            'view analytics',
            
            // Audit logs
            'view activity',
        ];

        foreach ($permissions as $permissionName) {
            Permission::firstOrCreate(['name' => $permissionName, 'guard_name' => 'web']);
        }

        // Assign permissions to roles
        $superAdmin = Role::findByName('super-admin');
        $superAdmin->givePermissionTo(Permission::all());

        $admin = Role::findByName('admin');
        $admin->givePermissionTo([
            'view services', 'create services', 'edit services', 'delete services',
            'view posts', 'create posts', 'edit posts', 'delete posts',
            'view team', 'create team', 'edit team', 'delete team',
            'view appointments', 'edit appointments', 'delete appointments',
            'view inquiries', 'delete inquiries',
            'view testimonials', 'approve testimonials', 'delete testimonials',
            'upload media', 'delete media',
            'view settings', 'edit settings',
            'view analytics',
            'view activity',
        ]);

        $counselor = Role::findByName('counselor');
        $counselor->givePermissionTo([
            'view own appointments',
            'edit appointments',
        ]);

        $editor = Role::findByName('editor');
        $editor->givePermissionTo([
            'view services', 'create services', 'edit services',
            'view posts', 'create posts', 'edit posts',
            'view team',
            'view inquiries',
            'view testimonials',
            'upload media',
        ]);

        // Guest role has no permissions by default
    }
}
