<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DownloadableResource;

class ResourceSeeder extends Seeder
{
    public function run(): void
    {
        // Clear existing resources
        DownloadableResource::truncate();

        $resources = [
            [
                'title' => 'Mindfulness Meditation Guide',
                'description' => 'A comprehensive guide to beginning your mindfulness practice with step-by-step instructions.',
                'category' => 'meditation',
                'type' => 'pdf',
                'download_count' => 1250,
                'duration' => '15 min read',
                'premium' => false,
                'file_path' => 'resources/mindfulness-meditation-guide.txt'
            ],
            [
                'title' => 'Anxiety Management Worksheet',
                'description' => 'Practical exercises to identify triggers and develop coping strategies for anxiety.',
                'category' => 'worksheets',
                'type' => 'pdf',
                'download_count' => 2100,
                'duration' => '20 min',
                'premium' => false,
                'file_path' => 'resources/anxiety-management-worksheet.txt'
            ],
            [
                'title' => 'Guided Body Scan Meditation',
                'description' => 'A calming audio guide to help you release tension and connect with your body.',
                'category' => 'meditation',
                'type' => 'audio',
                'download_count' => 890,
                'duration' => '25 min',
                'premium' => true,
                'file_path' => 'resources/sample-audio.txt'
            ],
            [
                'title' => 'Building Healthy Relationships',
                'description' => 'Learn communication techniques and boundary-setting for stronger relationships.',
                'category' => 'articles',
                'type' => 'pdf',
                'download_count' => 1560,
                'duration' => '12 min read',
                'premium' => false,
                'file_path' => 'resources/sample-article.txt'
            ],
            [
                'title' => 'Sleep Hygiene Checklist',
                'description' => 'Evidence-based tips and habits for improving your sleep quality naturally.',
                'category' => 'worksheets',
                'type' => 'pdf',
                'download_count' => 1890,
                'duration' => '5 min',
                'premium' => false,
                'file_path' => 'resources/sample-worksheet.txt'
            ],
            [
                'title' => 'Trauma Recovery Workbook',
                'description' => 'A gentle, self-paced workbook for processing and healing from trauma.',
                'category' => 'worksheets',
                'type' => 'pdf',
                'download_count' => 750,
                'duration' => 'Multi-session',
                'premium' => true,
                'file_path' => 'resources/sample-worksheet.txt'
            ],
            [
                'title' => 'Deep Breathing Exercises',
                'description' => 'Three powerful breathing techniques for instant calm and stress relief.',
                'category' => 'meditation',
                'type' => 'audio',
                'download_count' => 2340,
                'duration' => '10 min',
                'premium' => false,
                'file_path' => 'resources/sample-audio.txt'
            ],
            [
                'title' => 'Understanding Depression',
                'description' => 'An informative article about depression symptoms, causes, and treatment options.',
                'category' => 'articles',
                'type' => 'pdf',
                'download_count' => 1120,
                'duration' => '8 min read',
                'premium' => false,
                'file_path' => 'resources/sample-article.txt'
            ],
            [
                'title' => 'Couples Communication Cards',
                'description' => '50 conversation starters to deepen connection and improve communication.',
                'category' => 'worksheets',
                'type' => 'pdf',
                'download_count' => 670,
                'duration' => 'Ongoing',
                'premium' => true,
                'file_path' => 'resources/sample-worksheet.txt'
            ],
            [
                'title' => 'Evening Wind-Down Meditation',
                'description' => 'A soothing meditation to help you transition from day to peaceful sleep.',
                'category' => 'meditation',
                'type' => 'audio',
                'download_count' => 1560,
                'duration' => '20 min',
                'premium' => true,
                'file_path' => 'resources/sample-audio.txt'
            ],
            [
                'title' => 'Self-Compassion Journal Prompts',
                'description' => '30 days of journaling prompts to cultivate self-love and acceptance.',
                'category' => 'worksheets',
                'type' => 'pdf',
                'download_count' => 980,
                'duration' => '30 days',
                'premium' => false,
                'file_path' => 'resources/sample-worksheet.txt'
            ],
            [
                'title' => 'Parenting Through Challenges',
                'description' => 'Strategies for maintaining connection with your children during difficult times.',
                'category' => 'articles',
                'type' => 'pdf',
                'download_count' => 540,
                'duration' => '15 min read',
                'premium' => false,
                'file_path' => 'resources/sample-article.txt'
            ]
        ];

        foreach ($resources as $resource) {
            DownloadableResource::create($resource);
        }
    }
}
