<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PostSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::whereHas('roles', function ($query) {
            $query->where('name', 'admin');
        })->first();

        $posts = [
            [
                'title' => 'Understanding Anxiety: Causes, Symptoms, and Treatment',
                'excerpt' => 'Anxiety is one of the most common mental health challenges. Learn about its causes, how to recognize symptoms, and effective treatment approaches.',
                'content' => 'Anxiety disorders affect millions of people worldwide. Understanding the root causes and recognizing symptoms is the first step toward healing. In this comprehensive guide, we explore the various types of anxiety disorders, their symptoms, and evidence-based treatment options including cognitive behavioral therapy, mindfulness practices, and medication when appropriate. We also discuss lifestyle changes that can significantly reduce anxiety symptoms and improve overall well-being.',
                'is_draft' => false,
                'published_at' => now()->subMonths(2),
            ],
            [
                'title' => '5 Mindfulness Techniques for Daily Stress Relief',
                'excerpt' => 'Simple yet powerful mindfulness practices you can incorporate into your daily routine to manage stress and improve mental clarity.',
                'content' => 'Mindfulness doesn\'t require hours of meditation. These five practical techniques can be integrated into your daily life: 1) Mindful breathing exercises (5-10 minutes), 2) Body scan meditation, 3) Mindful walking, 4) Conscious eating practices, 5) Progressive muscle relaxation. Each technique is explained in detail with step-by-step instructions for beginners and advanced practitioners alike.',
                'is_draft' => false,
                'published_at' => now()->subMonths(1)->subWeeks(3),
            ],
            [
                'title' => 'The Power of Couples Counseling: When and Why to Seek Help',
                'excerpt' => 'Discover how couples counseling can strengthen relationships and when it\'s time to consider professional support for your partnership.',
                'content' => 'Many couples wait too long before seeking counseling, often when problems have become deeply entrenched. This article explores the benefits of couples counseling, common issues that bring couples to therapy, and how to know when it\'s time to seek help. We discuss the Gottman Method, Emotionally Focused Therapy, and other evidence-based approaches that help couples rebuild connection, improve communication, and resolve conflicts constructively.',
                'is_draft' => false,
                'published_at' => now()->subMonth()->subWeeks(2),
            ],
            [
                'title' => 'Healing from Trauma: A Journey of Recovery and Resilience',
                'excerpt' => 'An empowering guide to understanding trauma, its effects on the mind and body, and the path toward healing and post-traumatic growth.',
                'content' => 'Trauma impacts not just our minds but our entire being. This article provides a compassionate exploration of trauma responses, the neurobiology of PTSD, and effective therapeutic interventions including EMDR, somatic experiencing, and trauma-focused CBT. We emphasize that healing is possible and discuss the concept of post-traumatic growth – how trauma survivors can emerge stronger and more resilient.',
                'is_draft' => false,
                'published_at' => now()->subMonth()->subWeek(),
            ],
            [
                'title' => 'Building Emotional Resilience: Strategies for Life\'s Challenges',
                'excerpt' => 'Learn practical strategies to develop emotional resilience and navigate life\'s difficulties with greater ease and confidence.',
                'content' => 'Emotional resilience is not about avoiding difficulties but developing the capacity to bounce back from adversity. This comprehensive guide covers: building self-awareness, cultivating optimism, strengthening social connections, practicing self-compassion, and developing problem-solving skills. We provide actionable exercises and real-life examples of resilience in action.',
                'is_draft' => false,
                'published_at' => now()->subWeeks(3),
            ],
            [
                'title' => 'The Mind-Body Connection: Holistic Approaches to Mental Health',
                'excerpt' => 'Explore how physical health, nutrition, exercise, and sleep impact mental well-being and learn holistic strategies for optimal health.',
                'content' => 'Mental and physical health are inseparably connected. This article examines the latest research on how exercise reduces depression and anxiety, the impact of nutrition on mood and cognition, the critical role of sleep in mental health, and the benefits of practices like yoga and tai chi. We provide a holistic framework for understanding and optimizing your mental health through integrated mind-body approaches.',
                'is_draft' => false,
                'published_at' => now()->subWeeks(2),
            ],
            [
                'title' => 'Supporting a Loved One with Depression: A Caregiver\'s Guide',
                'excerpt' => 'Practical advice for family members and friends on how to support someone struggling with depression while maintaining your own well-being.',
                'content' => 'When someone you love is struggling with depression, you may feel helpless. This guide offers practical advice on: recognizing signs of depression, how to offer support without fixing, the importance of boundaries, encouraging professional help, and taking care of yourself as a caregiver. We emphasize that your role is to support, not to solve, and provide scripts for difficult conversations.',
                'is_draft' => false,
                'published_at' => now()->subWeek(),
            ],
            [
                'title' => 'Breaking the Stigma: Why Mental Health Care is Essential Healthcare',
                'excerpt' => 'Addressing the stigma surrounding mental health and advocating for mental health care as a fundamental aspect of overall health.',
                'content' => 'Mental health stigma prevents many people from seeking help. This article challenges common misconceptions, shares personal stories of recovery, and advocates for mental health care as an essential component of healthcare. We discuss how stigma affects help-seeking behavior, the importance of normalizing therapy, and how society can shift toward greater mental health awareness and acceptance.',
                'is_draft' => false,
                'published_at' => now()->subDays(4),
            ],
            [
                'title' => 'Self-Care is Not Selfish: Creating Your Personalized Wellness Plan',
                'excerpt' => 'A step-by-step guide to developing a sustainable self-care routine that nourishes your mind, body, and spirit.',
                'content' => 'Self-care is essential, not indulgent. This practical guide helps you create a personalized wellness plan that includes: identifying your needs, setting realistic goals, establishing daily rituals, incorporating movement and nutrition, managing stress, and maintaining social connections. We provide worksheets and templates to help you design a self-care plan that fits your lifestyle and values.',
                'is_draft' => false,
                'published_at' => now()->subDays(2),
            ],
            [
                'title' => 'The Science of Happiness: Research-Based Strategies for Well-Being',
                'excerpt' => 'Explore the latest positive psychology research and learn evidence-based practices to increase happiness and life satisfaction.',
                'content' => 'Happiness isn\'t just about positive emotions – it\'s about living a meaningful, engaged life. Drawing from positive psychology research, this article explores: the science of happiness, gratitude practices, the role of purpose and meaning, the importance of flow experiences, nurturing relationships, and acts of kindness. Each strategy is backed by scientific research and includes practical exercises.',
                'is_draft' => false,
                'published_at' => now()->subDay(),
            ],
            [
                'title' => 'Understanding Attachment Styles in Adult Relationships',
                'excerpt' => 'Learn how early attachment experiences shape adult relationships and how awareness can lead to healthier connections.',
                'content' => 'Attachment theory provides a powerful framework for understanding relationship patterns. This article explores the four attachment styles (secure, anxious, avoidant, and disorganized), how they develop in childhood, and their impact on adult relationships. We discuss how increased awareness of attachment patterns can lead to more secure, fulfilling relationships and provide strategies for developing earned security.',
                'is_draft' => true,
                'published_at' => null,
            ],
        ];

        foreach ($posts as $post) {
            $slug = Str::slug($post['title']);
            Post::updateOrCreate(
                ['slug' => $slug], // Find by slug
                [
                    'title' => $post['title'],
                    'excerpt' => $post['excerpt'],
                    'content' => $post['content'],
                    'author_id' => $admin ? $admin->id : null,
                    'is_draft' => $post['is_draft'],
                    'published_at' => $post['published_at'],
                ]
            );
        }
    }
}
