<?php

namespace Database\Seeders;

use App\Models\OurApproachPage;
use Illuminate\Database\Seeder;

class OurApproachPageSeeder extends Seeder
{
    public function run(): void
    {
        OurApproachPage::updateOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Transform Your Journey',
                'hero_subtitle' => 'We offer our clients a path to transformation - one that promotes insight, exploration, compassion, gratitude, and self-empowerment',
                'philosophy_title' => 'A Modern Approach',
                'philosophy_paragraph_1' => 'We ensure that our clients get individualized care based upon empirically backed, holistic approaches that considers biological, psychological, environmental, and socio-cultural aspects of our clients\' lives.',
                'philosophy_paragraph_2' => 'Pastoral counseling acknowledges that faith and spirituality can be integral parts of a person\'s identity and well-being. It incorporates these elements into the therapeutic process, providing a framework for understanding and addressing mental health challenges from a faith-based perspective.',
                'mbs_title' => 'The Mind-Body-Spirit Connection',
                'mbs_subtitle' => 'This approach recognizes that mental health is not solely a matter of the mind but also involves the body and spirit. By addressing all three aspects, pastoral counseling aims for a more comprehensive and effective healing process. Spiritual guidance and support draws on religious texts, prayer, and other spiritual practices to help clients find meaning, purpose, and resilience in their lives.',
                'pastoral_title' => 'Pastoral Counseling Techniques',
                'evidence_title' => 'Evidence-Based Therapeutic Methods',
                'evidence_subtitle' => 'While honoring your faith, we utilize proven clinical approaches that have been shown through research to be effective for mental health and emotional healing.',
                'choice_title' => 'Your Healing, Your Choice',
                'choice_paragraph_1' => 'Faith integration is always optional and tailored to your comfort level. Some clients seek explicitly faith-based counseling, while others prefer a secular approach that simply respects their spiritual background.',
                'choice_paragraph_2' => 'We honor your preferences and work collaboratively to create a therapeutic experience that feels safe, meaningful, and effective for you.',
            ]
        );
    }
}
