<?php

namespace Database\Seeders;

use App\Models\Notification;
use Illuminate\Database\Seeder;

class NotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $notifications = [
            [
                'title' => 'New Member Registration',
                'message' => 'Sarah Johnson has registered for Premium membership',
                'type' => 'info',
                'read' => false,
                'user_id' => null,
                'link' => null,
                'metadata' => ['member_id' => 1, 'membership_type' => 'premium'],
            ],
            [
                'title' => 'Appointment Confirmed',
                'message' => 'Michael Chen confirmed appointment for March 15 at 2:00 PM',
                'type' => 'success',
                'read' => false,
                'user_id' => null,
                'link' => null,
                'metadata' => ['appointment_id' => 1, 'client_name' => 'Michael Chen'],
            ],
            [
                'title' => 'Payment Received',
                'message' => 'Payment of $150 received from Emily Davis for session fees',
                'type' => 'success',
                'read' => true,
                'user_id' => null,
                'link' => null,
                'metadata' => ['amount' => 150, 'payment_method' => 'credit_card'],
            ],
            [
                'title' => 'Appointment Cancelled',
                'message' => 'David Wilson cancelled appointment for March 14 at 10:00 AM',
                'type' => 'warning',
                'read' => true,
                'user_id' => null,
                'link' => null,
                'metadata' => ['appointment_id' => 2, 'client_name' => 'David Wilson'],
            ],
            [
                'title' => 'Membership Expiring',
                'message' => "Jennifer Lee's membership expires in 7 days. Please renew to continue services.",
                'type' => 'warning',
                'read' => true,
                'user_id' => null,
                'link' => null,
                'metadata' => ['member_id' => 5, 'days_until_expiry' => 7],
            ],
            [
                'title' => 'System Update Completed',
                'message' => 'System maintenance completed successfully. All systems are operational.',
                'type' => 'success',
                'read' => true,
                'user_id' => null,
                'link' => null,
                'metadata' => ['update_version' => '2.1.0'],
            ],
            [
                'title' => 'Low Inventory Alert',
                'message' => 'Aromatherapy oils inventory is running low. Please reorder soon.',
                'type' => 'error',
                'read' => false,
                'user_id' => null,
                'link' => null,
                'metadata' => ['product_id' => 3, 'quantity_remaining' => 5],
            ],
            [
                'title' => 'New Session Request',
                'message' => 'Robert Martinez requested a session for anxiety management',
                'type' => 'info',
                'read' => false,
                'user_id' => null,
                'link' => null,
                'metadata' => ['request_id' => 1, 'client_name' => 'Robert Martinez'],
            ],
            [
                'title' => 'Therapist Scheduled Offline',
                'message' => 'Dr. Sarah Mitchell has blocked time for personal development training on March 20-22',
                'type' => 'info',
                'read' => true,
                'user_id' => null,
                'link' => null,
                'metadata' => ['therapist_id' => 1, 'reason' => 'Training'],
            ],
            [
                'title' => 'Payment Failed',
                'message' => 'Payment processing failed for Jessica Wong. Please contact for retry.',
                'type' => 'error',
                'read' => false,
                'user_id' => null,
                'link' => null,
                'metadata' => ['member_id' => 8, 'error_code' => 'declined'],
            ],
        ];

        foreach ($notifications as $notification) {
            Notification::create($notification);
        }

        $this->command->info('Notifications seeded successfully!');
    }
}
