<?php

namespace Database\Seeders;

use App\Models\Membership;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class MembershipSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $memberships = [
            [
                'name' => 'Basic',
                'slug' => 'basic',
                'description' => 'Perfect for getting started with your wellness journey',
                'price' => 29.99,
                'billing_cycle' => 'monthly',
                'benefits' => json_encode([
                    'Access to online resources library',
                    'Monthly wellness newsletter',
                    '10% discount on services',
                    'Community forum access',
                ]),
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Premium',
                'slug' => 'premium',
                'description' => 'Enhanced support for your mental health and wellness',
                'price' => 79.99,
                'billing_cycle' => 'monthly',
                'benefits' => json_encode([
                    'All Basic benefits',
                    '2 individual therapy sessions per month',
                    'Priority booking for appointments',
                    '20% discount on additional services',
                    'Access to exclusive workshops',
                    'Monthly wellness assessment',
                ]),
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Platinum',
                'slug' => 'platinum',
                'description' => 'Comprehensive care with unlimited support',
                'price' => 149.99,
                'billing_cycle' => 'monthly',
                'benefits' => json_encode([
                    'All Premium benefits',
                    'Unlimited therapy sessions',
                    'Dedicated wellness coach',
                    '30% discount on all services',
                    'Access to all workshops and retreats',
                    'Priority 24/7 support line',
                    'Personalized wellness plan',
                    'Family counseling included',
                ]),
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($memberships as $membership) {
            Membership::updateOrCreate(
                ['slug' => $membership['slug']], // Find by slug
                $membership // Update or create with this data
            );
        }
    }
}
