<?php

namespace Database\Seeders;

use App\Models\MembershipPage;
use Illuminate\Database\Seeder;

class MembershipPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        MembershipPage::updateOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Membership Plans',
                'hero_subtitle' => 'Choose the perfect plan for your wellness journey',
                'intro_title' => 'Invest in Your Mental Health',
                'intro_paragraph_1' => 'Our membership plans provide flexible, affordable access to comprehensive mental health care. Each plan is designed to support your unique journey toward healing and growth.',
                'intro_paragraph_2' => 'All memberships include access to our faith-integrated therapeutic approach, combining evidence-based practices with spiritual care.',
                
                'basic_title' => 'Basic',
                'basic_description' => 'Perfect for getting started on your wellness journey',
                'basic_price' => '$99/month',
                'basic_features' => [
                    '2 therapy sessions per month',
                    'Access to wellness resources',
                    'Email support',
                    'Group therapy sessions',
                ],
                'basic_image_path' => null,
                
                'premium_title' => 'Premium',
                'premium_description' => 'Comprehensive care for ongoing support',
                'premium_price' => '$199/month',
                'premium_features' => [
                    '4 therapy sessions per month',
                    'Priority scheduling',
                    'Access to all wellness resources',
                    'Email & phone support',
                    'Group therapy sessions',
                    'Monthly wellness check-ins',
                ],
                'premium_image_path' => null,
                
                'platinum_title' => 'Platinum',
                'platinum_description' => 'Premium care with maximum flexibility',
                'platinum_price' => '$299/month',
                'platinum_features' => [
                    'Unlimited therapy sessions',
                    'Priority scheduling',
                    'Access to all wellness resources',
                    '24/7 crisis support',
                    'Group therapy sessions',
                    'Weekly wellness check-ins',
                    'Couples & family sessions included',
                    'Personalized wellness plan',
                ],
                'platinum_image_path' => null,
                
                'cta_title' => 'Ready to Begin Your Journey?',
                'cta_description' => 'Join our community and take the first step toward lasting wellness',
                'cta_button_text' => 'Get Started Today',
            ]
        );
    }
}
