<?php

namespace Database\Seeders;

use App\Models\MembershipPage;
use Illuminate\Database\Seeder;

class MembershipComparisonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $page = MembershipPage::first();
        
        if (!$page) {
            $page = MembershipPage::create([]);
        }

        $comparisonFeatures = [
            [
                'name' => 'Individual Counseling Sessions',
                'basic' => '2/month',
                'premium' => '4/month',
                'platinum' => 'Unlimited',
            ],
            [
                'name' => 'Group Therapy Sessions',
                'basic' => true,
                'premium' => true,
                'platinum' => true,
            ],
            [
                'name' => 'Emergency Support Line',
                'basic' => false,
                'premium' => true,
                'platinum' => true,
            ],
            [
                'name' => 'Wellness Resources Library',
                'basic' => 'Basic',
                'premium' => 'Full Access',
                'platinum' => 'Full Access',
            ],
            [
                'name' => 'Guided Meditation Sessions',
                'basic' => false,
                'premium' => '2/month',
                'platinum' => 'Unlimited',
            ],
            [
                'name' => 'Couples/Family Sessions',
                'basic' => false,
                'premium' => '1/month',
                'platinum' => '4/month',
            ],
            [
                'name' => 'Priority Booking',
                'basic' => false,
                'premium' => true,
                'platinum' => true,
            ],
            [
                'name' => 'Personal Wellness Coach',
                'basic' => false,
                'premium' => false,
                'platinum' => true,
            ],
            [
                'name' => 'Weekend Retreat Access',
                'basic' => false,
                'premium' => '10% Off',
                'platinum' => '1 Free/Year',
            ],
            [
                'name' => 'Progress Tracking Dashboard',
                'basic' => true,
                'premium' => true,
                'platinum' => true,
            ],
            [
                'name' => 'Therapist Match Guarantee',
                'basic' => false,
                'premium' => true,
                'platinum' => true,
            ],
            [
                'name' => 'Home Visit Options',
                'basic' => false,
                'premium' => false,
                'platinum' => true,
            ],
        ];

        $page->update([
            'comparison_title' => 'Full Feature Comparison',
            'comparison_subtitle' => 'Compare all features across membership tiers',
            'comparison_features' => $comparisonFeatures,
        ]);

        $this->command->info('Membership comparison features seeded successfully!');
    }
}
