<?php

namespace Database\Seeders;

use App\Models\Member;
use App\Models\User;
use App\Models\Membership;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class MemberSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create sample member users and their memberships
        $memberships = Membership::all();

        // Create Basic tier members (reduced count for faster seeding)
        for ($i = 1; $i <= 50; $i++) {
            $email = "basic.member{$i}@example.com";
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => "Basic Member {$i}",
                    'password' => Hash::make('password'),
                    'email_verified_at' => now(),
                ]
            );

            Member::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'membership_id' => $memberships->where('slug', 'basic')->first()->id,
                    'status' => 'active',
                    'subscribed_at' => now()->subMonths(rand(1, 12)),
                    'expires_at' => now()->addMonth(),
                ]
            );
        }

        // Create Premium tier members (reduced count for faster seeding)
        for ($i = 1; $i <= 20; $i++) {
            $email = "premium.member{$i}@example.com";
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => "Premium Member {$i}",
                    'password' => Hash::make('password'),
                    'email_verified_at' => now(),
                ]
            );

            Member::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'membership_id' => $memberships->where('slug', 'premium')->first()->id,
                    'status' => 'active',
                    'subscribed_at' => now()->subMonths(rand(1, 12)),
                    'expires_at' => now()->addMonth(),
                ]
            );
        }

        // Create Platinum tier members (reduced count for faster seeding)
        for ($i = 1; $i <= 10; $i++) {
            $email = "platinum.member{$i}@example.com";
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => "Platinum Member {$i}",
                    'password' => Hash::make('password'),
                    'email_verified_at' => now(),
                ]
            );

            Member::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'membership_id' => $memberships->where('slug', 'platinum')->first()->id,
                    'status' => 'active',
                    'subscribed_at' => now()->subMonths(rand(1, 12)),
                    'expires_at' => now()->addMonth(),
                ]
            );
        }

        // Create some inactive members
        for ($i = 1; $i <= 5; $i++) {
            $email = "inactive.member{$i}@example.com";
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => "Inactive Member {$i}",
                    'password' => Hash::make('password'),
                    'email_verified_at' => now(),
                ]
            );

            Member::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'membership_id' => $memberships->random()->id,
                    'status' => 'inactive',
                    'subscribed_at' => now()->subMonths(rand(6, 24)),
                    'expires_at' => now()->subMonths(rand(1, 6)),
                ]
            );
        }
    }
}
