<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\HomePage;

class HomePageSeeder extends Seeder
{
    public function run(): void
    {
        HomePage::updateOrCreate(
            ['id' => 1],
            [
                // Hero Section
                'title' => 'A Sacred Space for',
                'subtitle' => 'Healing & Growth',
                'description' => 'Faith-integrated pastoral psychotherapy that nurtures your mind, body, and spirit',
                'hero_image' => '',
                'hero_slides' => [
                    [
                        'image' => '',
                        'title' => 'Welcome to MaaKaBa',
                        'subtitle' => 'Your Journey to Wellness Begins Here',
                        'description' => 'Experience compassionate, faith-integrated therapy in a safe and sacred space'
                    ],
                    [
                        'image' => '',
                        'title' => 'Healing Mind, Body & Spirit',
                        'subtitle' => 'Holistic Therapeutic Approach',
                        'description' => 'Integrating psychology and spirituality for complete transformation'
                    ],
                    [
                        'image' => '',
                        'title' => 'Professional Care',
                        'subtitle' => 'Licensed Therapists',
                        'description' => 'Expert guidance with compassion and understanding'
                    ],
                ],
                'call_to_action_text' => 'Book Your Session',
                'call_to_action_url' => '/contact',
                
                // About Section
                'about_title' => 'Welcome to MaaKaBa',
                'about_description' => 'A sanctuary where faith meets psychology, and healing touches every aspect of your being',
                'about_features' => [
                    [
                        'icon' => 'Heart',
                        'title' => 'Compassionate Care',
                        'description' => 'Every session is grounded in empathy, respect, and unconditional positive regard'
                    ],
                    [
                        'icon' => 'Sparkles',
                        'title' => 'Holistic Approach',
                        'description' => 'Integrating mind, body, and spirit for complete, transformative healing'
                    ],
                    [
                        'icon' => 'Shield',
                        'title' => 'Safe & Sacred Space',
                        'description' => 'A confidential environment where you can be vulnerable and find strength'
                    ],
                ],
                
                // Services Section
                'services_title' => 'Our Services',
                'services_description' => 'Tailored therapeutic approaches for every stage of your healing journey',
                'services_items' => [
                    [
                        'icon' => 'Heart',
                        'title' => 'Individual Counseling',
                        'description' => 'One-on-one sessions tailored to your unique journey of healing and growth.'
                    ],
                    [
                        'icon' => 'Users',
                        'title' => 'Family Therapy',
                        'description' => 'Strengthen family bonds and navigate challenges together with compassion.'
                    ],
                    [
                        'icon' => 'Sparkles',
                        'title' => 'Spiritual Guidance',
                        'description' => 'Integrate faith and psychology for holistic emotional and spiritual wellness.'
                    ],
                    [
                        'icon' => 'Shield',
                        'title' => 'Trauma Recovery',
                        'description' => 'Evidence-based approaches to heal from past wounds in a safe, sacred space.'
                    ],
                ],
                
                // Testimonials Section
                'testimonials_title' => 'Stories of Transformation',
                'testimonials_description' => 'Real journeys, real healing, real hope',
                'testimonials_items' => [
                    [
                        'name' => 'Sarah M.',
                        'text' => 'MaaKaBa provided the safe space I needed to heal. The integration of faith and therapy transformed my life.',
                        'rating' => 5
                    ],
                    [
                        'name' => 'James K.',
                        'text' => 'The team\'s compassion and professionalism helped our family through our darkest times. Forever grateful.',
                        'rating' => 5
                    ],
                    [
                        'name' => 'Lisa P.',
                        'text' => 'A truly holistic approach that addresses mind, body, and spirit. I finally feel whole again.',
                        'rating' => 5
                    ],
                ],
                
                // CTA Section
                'cta_title' => 'Begin Your Journey to Wellness',
                'cta_description' => 'Take the first step toward healing, growth, and transformation. We\'re here to walk alongside you with compassion and expertise.',
                'cta_button_text' => 'Schedule Your First Session',
                'cta_button_url' => '/contact',
            ]
        );
    }
}
