<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FaqSeeder extends Seeder
{
    public function run(): void
    {
        // Seed FAQ Page content
        DB::table('faq_page')->insert([
            'hero_title' => 'Frequently Asked Questions',
            'hero_subtitle' => 'Get instant answers to common questions about our services',
            'hero_image_path' => null,
            'intro_title' => 'Ask Our Assistant',
            'intro_description' => 'Type your question below and get instant answers about our services, pricing, scheduling, and more. We\'re here to help!',
            'cta_title' => 'Still Have Questions?',
            'cta_description' => 'Our team is here to help. Contact us directly for personalized assistance.',
            'cta_button_text' => 'Contact Us',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Seed FAQ Items
        $faqItems = [
            // General Questions
            [
                'category' => 'General',
                'question' => 'What is MaaKaBa Sanctuary?',
                'answer' => 'MaaKaBa Sanctuary is a professional counseling and therapy center dedicated to providing compassionate, evidence-based mental health services. We offer a safe, welcoming space where individuals, couples, and families can find healing and support.',
                'keywords' => json_encode(['about', 'who', 'what', 'maakaba', 'sanctuary']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'General',
                'question' => 'Where are you located?',
                'answer' => 'We are conveniently located in the heart of the city with easy access to public transportation and parking. Please visit our Contact page for detailed directions and location information.',
                'keywords' => json_encode(['location', 'address', 'where', 'directions', 'parking']),
                'display_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'General',
                'question' => 'What are your hours of operation?',
                'answer' => 'We offer flexible scheduling to accommodate your needs. Our office is open Monday through Friday from 8:00 AM to 8:00 PM, and Saturdays from 9:00 AM to 5:00 PM. We also offer some evening and weekend appointments.',
                'keywords' => json_encode(['hours', 'schedule', 'time', 'open', 'availability']),
                'display_order' => 3,
                'is_active' => true,
            ],

            // Services Questions
            [
                'category' => 'Services',
                'question' => 'What types of therapy do you offer?',
                'answer' => 'We offer a comprehensive range of therapeutic services including Individual Counseling, Couples Therapy, Family Therapy, Teen Counseling, and Trauma Therapy. Each service is tailored to meet your specific needs and goals.',
                'keywords' => json_encode(['services', 'therapy', 'counseling', 'types', 'offer']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'Services',
                'question' => 'Do you offer online/virtual therapy sessions?',
                'answer' => 'Yes! We offer secure, HIPAA-compliant virtual therapy sessions via video conferencing. This allows you to receive quality care from the comfort of your own home. Virtual sessions are available for most of our services.',
                'keywords' => json_encode(['online', 'virtual', 'telehealth', 'video', 'remote']),
                'display_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'Services',
                'question' => 'How long is a typical therapy session?',
                'answer' => 'Standard therapy sessions are 50-60 minutes long. However, we also offer extended sessions and intensive therapy options depending on your needs. Your therapist will work with you to determine the best session length for your situation.',
                'keywords' => json_encode(['duration', 'length', 'time', 'session', 'how long']),
                'display_order' => 3,
                'is_active' => true,
            ],

            // Booking Questions
            [
                'category' => 'Booking',
                'question' => 'How do I schedule an appointment?',
                'answer' => 'Scheduling is easy! You can book an appointment online through our website, call our office directly, or send us a message through our contact form. We\'ll respond promptly to confirm your appointment and answer any questions.',
                'keywords' => json_encode(['schedule', 'book', 'appointment', 'how to', 'booking']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'Booking',
                'question' => 'What should I expect during my first session?',
                'answer' => 'Your first session is an opportunity to get to know your therapist and discuss your concerns. We\'ll review your background, current challenges, and goals for therapy. This helps us create a personalized treatment plan tailored to your needs.',
                'keywords' => json_encode(['first', 'initial', 'intake', 'expect', 'session']),
                'display_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'Booking',
                'question' => 'What is your cancellation policy?',
                'answer' => 'We require at least 24 hours notice for cancellations or rescheduling. Late cancellations or no-shows may be subject to a fee. We understand that emergencies happen, so please contact us as soon as possible if you need to change your appointment.',
                'keywords' => json_encode(['cancel', 'cancellation', 'reschedule', 'policy', 'no-show']),
                'display_order' => 3,
                'is_active' => true,
            ],

            // Pricing Questions
            [
                'category' => 'Pricing',
                'question' => 'How much do your services cost?',
                'answer' => 'Our fees vary depending on the type of service and therapist. Individual sessions typically range from $100-$200 per session. We offer a sliding scale for those who qualify and accept various insurance plans. Please contact us for specific pricing information.',
                'keywords' => json_encode(['cost', 'price', 'fee', 'how much', 'payment']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'Pricing',
                'question' => 'What payment methods do you accept?',
                'answer' => 'We accept cash, credit cards (Visa, MasterCard, American Express), debit cards, and HSA/FSA cards. Payment is due at the time of service unless other arrangements have been made in advance.',
                'keywords' => json_encode(['payment', 'methods', 'accept', 'credit card', 'cash']),
                'display_order' => 2,
                'is_active' => true,
            ],

            // Insurance Questions
            [
                'category' => 'Insurance',
                'question' => 'Do you accept insurance?',
                'answer' => 'Yes, we accept most major insurance plans. We are in-network with many providers and can also provide superbills for out-of-network reimbursement. Please contact us with your insurance information to verify coverage.',
                'keywords' => json_encode(['insurance', 'coverage', 'accept', 'in-network', 'plans']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'Insurance',
                'question' => 'What if my insurance doesn\'t cover therapy?',
                'answer' => 'If your insurance doesn\'t cover therapy or you don\'t have insurance, we offer self-pay options and a sliding scale fee structure based on income. We believe everyone deserves access to quality mental health care.',
                'keywords' => json_encode(['no insurance', 'self-pay', 'sliding scale', 'afford', 'cost']),
                'display_order' => 2,
                'is_active' => true,
            ],

            // Therapy Process Questions
            [
                'category' => 'Therapy',
                'question' => 'Is therapy confidential?',
                'answer' => 'Yes, confidentiality is a cornerstone of therapy. Everything you share is protected by law and professional ethics. There are only a few exceptions, such as if there is a risk of harm to yourself or others, or if required by court order.',
                'keywords' => json_encode(['confidential', 'privacy', 'private', 'secret', 'hipaa']),
                'display_order' => 1,
                'is_active' => true,
            ],
            [
                'category' => 'Therapy',
                'question' => 'How long will I need therapy?',
                'answer' => 'The length of therapy varies for each person and depends on your goals, the issues you\'re addressing, and your progress. Some people benefit from short-term therapy (8-12 sessions), while others prefer longer-term support. We\'ll regularly review your progress together.',
                'keywords' => json_encode(['duration', 'how long', 'length', 'time', 'sessions']),
                'display_order' => 2,
                'is_active' => true,
            ],
            [
                'category' => 'Therapy',
                'question' => 'Can I choose my therapist?',
                'answer' => 'Absolutely! We believe the therapeutic relationship is crucial to success. You can browse our team members\' profiles and request a specific therapist. If you\'re not sure who to choose, we can help match you with a therapist based on your needs and preferences.',
                'keywords' => json_encode(['choose', 'select', 'therapist', 'match', 'preference']),
                'display_order' => 3,
                'is_active' => true,
            ],
        ];

        foreach ($faqItems as $item) {
            DB::table('faq_items')->insert(array_merge($item, [
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
