<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ContactPage;

class ContactPageSeeder extends Seeder
{
    public function run(): void
    {
        // Check if record exists
        $contactPage = ContactPage::first();
        
        if ($contactPage) {
            // Update existing record
            $contactPage->update([
                'hero_title' => 'Get in Touch',
                'hero_subtitle' => 'Take the first step toward healing. We\'re here to help.',
                'form_title' => 'Book Your Session',
                'form_description' => 'Fill out the form below and we\'ll reach out to schedule your first appointment. All inquiries are confidential.',
                'info_title' => 'Contact Information',
                'info_description' => 'Reach out to us directly or visit our sanctuary. We look forward to connecting with you.',
                'phone' => '(555) 123-4567',
                'phone_hours' => 'Available Mon-Fri, 9am-6pm',
                'email' => 'info@maakaba.com',
                'email_response_time' => 'We respond within 24 hours',
                'address_line1' => '123 Healing Way',
                'address_line2' => 'Sanctuary City, SC 12345',
                'office_hours' => "Monday - Friday: 9:00 AM - 6:00 PM\nSaturday: 10:00 AM - 4:00 PM\nSunday: Closed",
                'emergency_title' => 'Emergency Support',
                'emergency_description' => 'If you\'re experiencing a mental health emergency, please call 911 or the National Crisis Hotline:',
                'emergency_number' => '988',
            ]);
        } else {
            // Create new record
            ContactPage::create([
                'hero_title' => 'Get in Touch',
                'hero_subtitle' => 'Take the first step toward healing. We\'re here to help.',
                'hero_image_path' => null,
                'form_title' => 'Book Your Session',
                'form_description' => 'Fill out the form below and we\'ll reach out to schedule your first appointment. All inquiries are confidential.',
                'info_title' => 'Contact Information',
                'info_description' => 'Reach out to us directly or visit our sanctuary. We look forward to connecting with you.',
                'phone' => '(555) 123-4567',
                'phone_hours' => 'Available Mon-Fri, 9am-6pm',
                'email' => 'info@maakaba.com',
                'email_response_time' => 'We respond within 24 hours',
                'address_line1' => '123 Healing Way',
                'address_line2' => 'Sanctuary City, SC 12345',
                'office_hours' => "Monday - Friday: 9:00 AM - 6:00 PM\nSaturday: 10:00 AM - 4:00 PM\nSunday: Closed",
                'emergency_title' => 'Emergency Support',
                'emergency_description' => 'If you\'re experiencing a mental health emergency, please call 911 or the National Crisis Hotline:',
                'emergency_number' => '988',
                'map_embed_url' => null,
                'map_image_path' => null,
            ]);
        }
    }
}
