<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class CompleteBookingSystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Starting Complete Booking System Seeding...');
        
        // Step 1: Create Therapists
        $this->command->info('Step 1: Creating therapists...');
        $this->call(TherapistSeeder::class);
        
        // Step 2: Clear old data
        $this->command->info('Step 2: Clearing old data...');
        \DB::table('therapist_schedules')->delete();
        \DB::table('appointments')->delete();
        
        // Step 3: Create Appointments with Therapists
        $this->command->info('Step 3: Creating appointments...');
        $this->call(AppointmentSeeder::class);
        
        // Step 4: Create Therapist Schedules
        $this->command->info('Step 4: Creating therapist schedules...');
        $this->call(TherapistScheduleSeeder::class);
        
        $this->command->info('✓ Complete Booking System Seeded Successfully!');
    }
}
