<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;

class AppointmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get therapist IDs
        $therapists = DB::table('users')
            ->join('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')
            ->join('roles', 'model_has_roles.role_id', '=', 'roles.id')
            ->where('roles.name', 'counselor')
            ->pluck('users.id')
            ->toArray();

        if (empty($therapists)) {
            $this->command->warn('No therapists found. Run TherapistSeeder first.');
            return;
        }

        $referralSources = ['Website', 'Social Media', 'Word of Mouth', 'Church Referral', 'Walk-in', 'Professional Referral'];

        $appointments = [
            // Past appointments
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Sarah Mitchell',
                'email' => 'sarah.mitchell@example.com',
                'phone' => '555-0101',
                'date_of_birth' => Carbon::now()->subYears(34)->toDateString(),
                'preferred_date' => Carbon::now()->subDays(5)->setTime(10, 0),
                'status' => 'completed',
                'type' => 'individual',
                'referral_source' => 'Website',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.100',
                'created_at' => Carbon::now()->subDays(7),
                'updated_at' => Carbon::now()->subDays(5),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Michael Chen',
                'email' => 'michael.chen@example.com',
                'phone' => '555-0102',
                'date_of_birth' => Carbon::now()->subYears(45)->toDateString(),
                'preferred_date' => Carbon::now()->subDays(3)->setTime(14, 0),
                'status' => 'completed',
                'type' => 'couples',
                'referral_source' => 'Social Media',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.101',
                'created_at' => Carbon::now()->subDays(5),
                'updated_at' => Carbon::now()->subDays(3),
            ],

            // Today's appointments
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Emily Rodriguez',
                'email' => 'emily.rodriguez@example.com',
                'phone' => '555-0103',
                'date_of_birth' => Carbon::now()->subYears(28)->toDateString(),
                'preferred_date' => Carbon::today()->setTime(9, 0),
                'status' => 'confirmed',
                'type' => 'individual',
                'referral_source' => 'Word of Mouth',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.102',
                'created_at' => Carbon::now()->subDays(2),
                'updated_at' => Carbon::now()->subDays(1),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'David Thompson',
                'email' => 'david.thompson@example.com',
                'phone' => '555-0104',
                'date_of_birth' => Carbon::now()->subYears(52)->toDateString(),
                'preferred_date' => Carbon::today()->setTime(11, 0),
                'status' => 'confirmed',
                'type' => 'trauma',
                'referral_source' => 'Church Referral',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.103',
                'created_at' => Carbon::now()->subDays(3),
                'updated_at' => Carbon::now()->subDays(1),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Lisa Anderson',
                'email' => 'lisa.anderson@example.com',
                'phone' => '555-0105',
                'date_of_birth' => Carbon::now()->subYears(38)->toDateString(),
                'preferred_date' => Carbon::today()->setTime(15, 0),
                'status' => 'confirmed',
                'type' => 'family',
                'referral_source' => 'Website',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.104',
                'created_at' => Carbon::now()->subDays(4),
                'updated_at' => Carbon::now()->subDays(1),
            ],

            // Tomorrow's appointments
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'James Wilson',
                'email' => 'james.wilson@example.com',
                'phone' => '555-0106',
                'date_of_birth' => Carbon::now()->subYears(41)->toDateString(),
                'preferred_date' => Carbon::tomorrow()->setTime(10, 0),
                'status' => 'confirmed',
                'type' => 'individual',
                'referral_source' => 'Professional Referral',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.105',
                'created_at' => Carbon::now()->subDays(1),
                'updated_at' => Carbon::now()->subDays(1),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Maria Garcia',
                'email' => 'maria.garcia@example.com',
                'phone' => '555-0107',
                'date_of_birth' => Carbon::now()->subYears(35)->toDateString(),
                'preferred_date' => Carbon::tomorrow()->setTime(13, 0),
                'status' => 'confirmed',
                'type' => 'couples',
                'referral_source' => 'Social Media',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.106',
                'created_at' => Carbon::now()->subDays(2),
                'updated_at' => Carbon::now()->subDays(1),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Robert Taylor',
                'email' => 'robert.taylor@example.com',
                'phone' => '555-0108',
                'date_of_birth' => Carbon::now()->subYears(19)->toDateString(),
                'preferred_date' => Carbon::tomorrow()->setTime(16, 0),
                'status' => 'confirmed',
                'type' => 'teen',
                'referral_source' => 'Walk-in',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.107',
                'created_at' => Carbon::now()->subDays(1),
                'updated_at' => Carbon::now()->subDays(1),
            ],

            // Pending appointments (next week)
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Jennifer Brown',
                'email' => 'jennifer.brown@example.com',
                'phone' => '555-0109',
                'date_of_birth' => Carbon::now()->subYears(31)->toDateString(),
                'preferred_date' => Carbon::now()->addDays(3)->setTime(10, 0),
                'status' => 'pending',
                'type' => 'individual',
                'referral_source' => 'Word of Mouth',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.108',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'William Martinez',
                'email' => 'william.martinez@example.com',
                'phone' => '555-0110',
                'date_of_birth' => Carbon::now()->subYears(48)->toDateString(),
                'preferred_date' => Carbon::now()->addDays(4)->setTime(14, 0),
                'status' => 'pending',
                'type' => 'family',
                'referral_source' => 'Church Referral',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.109',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Amanda Johnson',
                'email' => 'amanda.johnson@example.com',
                'phone' => '555-0111',
                'date_of_birth' => Carbon::now()->subYears(42)->toDateString(),
                'preferred_date' => Carbon::now()->addDays(5)->setTime(11, 0),
                'status' => 'pending',
                'type' => 'trauma',
                'referral_source' => 'Website',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.110',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Christopher Lee',
                'email' => 'christopher.lee@example.com',
                'phone' => '555-0112',
                'date_of_birth' => Carbon::now()->subYears(36)->toDateString(),
                'preferred_date' => Carbon::now()->addDays(6)->setTime(15, 0),
                'status' => 'pending',
                'type' => 'couples',
                'referral_source' => 'Social Media',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.111',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],

            // Cancelled appointment
            [
                'booking_reference' => 'BK-' . strtoupper(Str::random(8)),
                'client_name' => 'Patricia White',
                'email' => 'patricia.white@example.com',
                'phone' => '555-0113',
                'date_of_birth' => Carbon::now()->subYears(55)->toDateString(),
                'preferred_date' => Carbon::now()->addDays(2)->setTime(9, 0),
                'status' => 'cancelled',
                'type' => 'individual',
                'referral_source' => 'Professional Referral',
                'counselor_id' => null,
                'notes' => null,
                'ip_address' => '192.168.1.112',
                'created_at' => Carbon::now()->subDays(3),
                'updated_at' => Carbon::now()->subHours(2),
            ],
        ];

        foreach ($appointments as $appointment) {
            DB::table('appointments')->insert($appointment);
        }

        $this->command->info('Created ' . count($appointments) . ' sample appointments with referral sources and birth dates');
    }
}
