<?php

namespace Database\Seeders;

use App\Models\ActivityLog;
use App\Models\User;
use Illuminate\Database\Seeder;

class ActivityLogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::whereHas('roles', function ($query) {
            $query->where('name', 'admin');
        })->first();

        if (!$admin) {
            return;
        }

        $activities = [
            [
                'actor_id' => $admin->id,
                'action' => 'membership.registered',
                'model_type' => 'App\Models\Member',
                'model_id' => 1,
                'meta' => json_encode(['membership_type' => 'Premium']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subMinutes(2),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'page.updated',
                'model_type' => 'App\Models\Page',
                'model_id' => 1,
                'meta' => json_encode(['page' => 'Homepage', 'section' => 'hero']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subHours(1),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'testimonial.submitted',
                'model_type' => 'App\Models\Testimonial',
                'model_id' => 11,
                'meta' => json_encode(['client' => 'New Submission', 'status' => 'pending_moderation']),
                'ip' => '192.168.1.105',
                'user_agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7)',
                'created_at' => now()->subHours(3),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'page.updated',
                'model_type' => 'App\Models\Service',
                'model_id' => 2,
                'meta' => json_encode(['service' => 'Couples Counseling', 'field' => 'content']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subDay(),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'appointment.confirmed',
                'model_type' => 'App\Models\Appointment',
                'model_id' => rand(1, 50),
                'meta' => json_encode(['client' => 'Sarah Johnson', 'date' => now()->addDays(3)->format('Y-m-d H:i')]),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subDay()->subHours(4),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'blog.published',
                'model_type' => 'App\Models\Post',
                'model_id' => 1,
                'meta' => json_encode(['title' => 'Understanding Anxiety', 'category' => 'Mental Health']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subDays(2),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'membership.upgraded',
                'model_type' => 'App\Models\Member',
                'model_id' => 25,
                'meta' => json_encode(['from' => 'Basic', 'to' => 'Premium']),
                'ip' => '192.168.1.110',
                'user_agent' => 'Mozilla/5.0 (iPhone; CPU iPhone OS 15_0)',
                'created_at' => now()->subDays(2)->subHours(5),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'settings.updated',
                'model_type' => 'App\Models\SiteSetting',
                'model_id' => 1,
                'meta' => json_encode(['setting' => 'site_name', 'value' => 'MaaKaBa Holistic Counseling Sanctuary']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subDays(3),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'team.member_added',
                'model_type' => 'App\Models\TeamMember',
                'model_id' => 5,
                'meta' => json_encode(['name' => 'Dr. Emily Wong', 'role' => 'Child & Adolescent Specialist']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subWeeks(1),
            ],
            [
                'actor_id' => $admin->id,
                'action' => 'testimonial.approved',
                'model_type' => 'App\Models\Testimonial',
                'model_id' => 10,
                'meta' => json_encode(['client' => 'Patricia L.', 'status' => 'approved']),
                'ip' => '192.168.1.100',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
                'created_at' => now()->subWeeks(2),
            ],
        ];

        foreach ($activities as $activity) {
            ActivityLog::create($activity);
        }
    }
}
