<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;

class AboutPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Page::updateOrCreate(
            ['slug' => 'about'],
            [
                'title' => 'Our Story & Mission',
                'is_published' => true,
                'published_at' => now(),
                'sections' => [
                    'hero' => [
                        'title' => 'Our Story & Mission',
                        'subtitle' => 'Creating a sanctuary where healing, faith, and psychology unite',
                    ],
                    'mission' => [
                        'title' => 'Who We Are',
                        'content' => 'MaaKaBa Holistic Counseling Sanctuary offers a compassionate and collaborative approach to emotional wellness and psychological health. MaaKaBa specializes in treating sadness, anxiety, anger, difficulty sleeping, changes in appetite, feelings of worthlessness, depression, and trauma with a particular focus on teens, adults, and families.',
                        'content2' => 'MaaKaBa\'s holistic care considers each individual\'s unique biological, psychological, and socio-cultural factors, fostering a path to healing that is authentic, empowering, and grounded in strong client-clinician relationships.',
                        'content3' => 'We are a group of clinicians who provide quality mental health care and services. We offer our clients a path to transformation - one that promotes insight, exploration, compassion, gratitude, and self-empowerment. We acknowledge that by healing our past unmet needs, unhealed hurts and unresolved issues, silencing the inner critic that limits us, and transforming our thoughts and behaviors, we can elevate our emotions and create an authentic life filled with meaning, well-being, purpose, and joy.',
                    ],
                    'pastoral' => [
                        'title' => 'What is Pastoral Psychotherapy?',
                        'content' => 'MaaKaBa has a pastoral psychotherapy holistic approach, integrating spiritual guidance and psychological techniques to address mental health challenges. This approach acknowledges the interconnectedness of mind, body, and spirit, viewing them as a unified whole. Pastoral counselors, trained in both theology and mental health, offer support by integrating faith, religious beliefs, and psychological principles to foster healing and personal growth.',
                        'description' => 'Pastoral counseling acknowledges that faith and spirituality can be integral parts of a person\'s identity and well-being. It incorporates these elements into the therapeutic process, providing a framework for understanding and addressing mental health challenges from a faith-based perspective.',
                        'points' => [
                            'Integration of faith and psychology - acknowledging that faith and spirituality can be integral parts of a person\'s identity and well-being',
                            'Mind, body, and spirit connection - recognizing that mental health involves all three aspects for comprehensive healing',
                            'Spiritual guidance and support - drawing on religious texts, prayer, and other spiritual practices to help clients find meaning, purpose, and resilience',
                            'Safe and supportive environment - creating a space to explore spiritual beliefs and experiences alongside psychological challenges without judgment',
                            'Addressing a range of issues - equipped to address anxiety, depression, grief, relationship problems, and spiritual crises',
                        ],
                        'footer' => 'In essence, pastoral psychotherapy\'s holistic approach seeks to provide a path towards healing and well-being by integrating the spiritual, psychological, and physical dimensions of human experience.',
                    ],
                    'values' => [
                        'title' => 'Our Core Values',
                        'items' => [
                            [
                                'icon' => 'Heart',
                                'title' => 'Compassion',
                                'description' => 'We meet every person with empathy, warmth, and unconditional positive regard.',
                            ],
                            [
                                'icon' => 'BookOpen',
                                'title' => 'Integration',
                                'description' => 'We blend evidence-based psychology with faith-based wisdom for holistic healing.',
                            ],
                            [
                                'icon' => 'Sparkles',
                                'title' => 'Transformation',
                                'description' => 'We believe in the power of growth, change, and the resilience of the human spirit.',
                            ],
                            [
                                'icon' => 'Shield',
                                'title' => 'Confidentiality',
                                'description' => 'Your trust is sacred. We uphold the highest standards of privacy and ethics.',
                            ],
                        ],
                    ],
                    'mission_statement' => [
                        'title' => 'Our Mission',
                        'content' => 'To provide compassionate, faith-integrated counseling that nurtures the whole person. We are committed to creating a sanctuary where individuals, families, and communities can find healing, discover hope, and experience transformation through the integration of psychological expertise and spiritual wisdom.',
                    ],
                ],
            ]
        );
    }
}
